#ifndef _SQLEXPORT_CPP
#define _SQLEXPORT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLExport.H"
#include "Console.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

const char *NULLSTR = "NULL";
const int NULLSTRLEN = 4;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteNull(FILE *TargetHandle)
{
    fwrite(&NULLSTRLEN, sizeof(NULLSTRLEN), 1, TargetHandle);
    fwrite(NULLSTR, sizeof(char), NULLSTRLEN, TargetHandle);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReplaceSingleQuotes(char *Data, int Length)
{
    int RPos = 0;

    while(RPos < Length)
    {
        if(Data[RPos] == '\'')
		{
            Data[RPos] = '`';
		}
        RPos++;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLINTEGER CharTrim(char *Data, int Length)
{
    SQLINTEGER Pos = Length;

    if(Length == 0)
        return Length;

    if(Data[Length-1] != ' ')
        return Length;

    Pos--;

    while(Pos != 0 && Data[Pos] == ' ')
        Pos--;

    if(Data[Pos] != ' ')
        Pos++;

    Data[Pos] = '\0';

    return Pos;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ExportSQLResults(CSockSrvr *pSockSrvr, int iClient, char *Statement, char *OutFileName)
{
	FILE *TargetHandle = NULL;

	CRecordSet rsTemp;

    SQLRETURN SQLResult = 0;

	//char sStmt[255];
    char sStatusText[MAX_STATUS_TEXT]; //Just some RAM for status text and error messages.
    char sAltTemp[MAX_STATUS_TEXT];    //Just some RAM for status text and error messages.
    char sOutColumnName[256];

    int iInColumnNameLen = 256;
	int iOutColumnSize = 0;
    int iOutColumnNameLen = 0;
    int *iOutDataType = 0;
    int iOutDecimalDigits = 0;
    int iOutNullable = 0;
    int iColumn = 0;

	if(!CCI.cCustSQL.Execute(Statement, &rsTemp))
    {
        sprintf(sStatusText, "ExportSQLResults SELECT Execute: Fail on (%s)", Statement);

		sprintf(sStatusText, "Statement: %s", Statement);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

		//Need to do some advanced error reporting.
		if(CCI.cCustSQL.GetErrorMessage(sAltTemp, rsTemp.hSTMT))
		{
			sprintf(sStatusText, "Error Msg: %s", sAltTemp);
			WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
		}

		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
        return SQL_IMPORT_RESULT_ERROR;
    }

	/*
	sprintf(sStmt, "UPDATE %s SET Portal_Dirty = 3 WHERE Portal_Dirty = 2", CCI.sImportTable);
    if(!CCI.cCustSQL.ExecuteNonQuery(sStmt))
    {
        sprintf(sStatusText, "UPDATE Execute: Fail on (%s)", sStmt);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

        rsTemp.Close();
        return SQL_IMPORT_RESULT_ERROR;
    }
	*/

    int iOutColCount = rsTemp.ColCount;
    int iOutRowCount = rsTemp.RowCount;

    if(iOutRowCount == 0)
    {
		//WriteLog(pSockSrvr->icClientID[iClient], "Query returned zero rows.");

        rsTemp.Close();
        return SQL_IMPORT_RESULT_ZEROROWS;
    }
    else{
        sprintf(sStatusText, "Query returned %d rows with %d columns.", iOutRowCount, iOutColCount);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
    }

    if((TargetHandle = fopen(OutFileName, "wb")) == NULL)
    {
        sprintf(sStatusText, "TargetFile: Binary write error with (%s).", OutFileName);
		WriteLog(pSockSrvr->icClientID[iClient], sStatusText);

        rsTemp.Close();
        return SQL_IMPORT_RESULT_ERROR;
    }

    int iImportTableNameLen = strlen(CCI.sImportTable);
    fwrite(&iImportTableNameLen, sizeof(iImportTableNameLen), 1, TargetHandle); // Write import table name len
    fwrite(CCI.sImportTable, sizeof(char), iImportTableNameLen, TargetHandle); // Write import table name
    fwrite(&iOutColCount, sizeof(iOutColCount), 1, TargetHandle); // Write number of columns
    fwrite(&iOutRowCount, sizeof(iOutRowCount), 1, TargetHandle);       // Write number of rows

    //---------------( Get column Information )---

	iOutDataType = (int *) calloc( sizeof(int), iOutColCount);

    while(rsTemp.GetColInfo(iColumn + 1, sOutColumnName, iInColumnNameLen, &iOutColumnNameLen,
		&iOutDataType[iColumn], &iOutColumnSize, &iOutDecimalDigits, &iOutNullable))
	{
        fwrite(&iOutDataType, sizeof(iOutDataType), 1, TargetHandle);
        fwrite(&iOutColumnSize, sizeof(iOutColumnSize), 1, TargetHandle);
        fwrite(&iOutColumnNameLen, sizeof(iOutColumnNameLen), 1, TargetHandle);
        fwrite(sOutColumnName, sizeof(char), iOutColumnNameLen, TargetHandle);

		iColumn++;
    }

    //---------------( Get column Data )---
    while(rsTemp.Fetch())
    {
        int iDataLen = 0;

        iColumn = 0;
        while(iColumn < iOutColCount)
        {
            int iDataType = iOutDataType[iColumn];

            if(iDataType == SQL_CHAR || iDataType == SQL_VARCHAR || iDataType == SQL_LONGVARCHAR || iDataType == SRV_TDS_NTEXT)
            {
                char sSQLBuffer1[10240 + 1];
				memset(sSQLBuffer1, 0, sizeof(sSQLBuffer1));

                //if(DBGetData(StatementHandle, iColumn+1, SQL_C_CHAR, sSQLBuffer1, 1024, &iDataLen))
				if(rsTemp.sColumnEx(iColumn + 1, sSQLBuffer1, sizeof(sSQLBuffer1), &iDataLen))
                {
                    if(iDataLen == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
						sSQLBuffer1[iDataLen] = '\0';
                        iDataLen = CharTrim(sSQLBuffer1, iDataLen);
                        ReplaceSingleQuotes(sSQLBuffer1, iDataLen);

                        iDataLen = (iDataLen + 2); // To make room for the single quotes
                        fwrite(&iDataLen, sizeof(iDataLen), 1, TargetHandle);
                        iDataLen = (iDataLen - 2); // Because we only write the origional trimmed length

                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                        fwrite(sSQLBuffer1, sizeof(char), iDataLen, TargetHandle);
                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
					}
				}
				else{
	                sprintf(sStatusText, "Failed to retreive data from column. Table: %s, Column: %d, Type: %d", CCI.sImportTable, iColumn, iDataType);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
				}
            }
            else if(iDataType == SQL_TYPE_DATE || iDataType == SQL_TYPE_TIME || iDataType == SQL_TYPE_TIMESTAMP)
            {
				char sSQLBuffer2[255];

                //if(DBGetData(StatementHandle, iColumn+1, SQL_C_CHAR, sSQLBuffer2, 255, &iDataLen))
                if(rsTemp.sColumnEx(iColumn + 1, sSQLBuffer2, sizeof(sSQLBuffer2), &iDataLen))
				{
                    if(iDataLen == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
	                    sSQLBuffer2[iDataLen] = '\0';
                        iDataLen = CharTrim(sSQLBuffer2, iDataLen);
                        ReplaceSingleQuotes(sSQLBuffer2, iDataLen);

                        iDataLen = (iDataLen + 2); // To make room for the single quotes
                        fwrite(&iDataLen, sizeof(iDataLen), 1, TargetHandle);
                        iDataLen = (iDataLen - 2); // Because we only write the origional trimmed length

                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                        fwrite(sSQLBuffer2, sizeof(char), iDataLen, TargetHandle);
                        fwrite("'", 1, 1, TargetHandle); // Wrap the data in single quotes
                    }
                }
				else{
	                sprintf(sStatusText, "Failed to retreive data from column. Table: %s, Column: %d, Type: %d", CCI.sImportTable, iColumn, iDataType);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
				}
			}
            else if(iDataType == SQL_INTEGER || iDataType == SQL_DECIMAL || iDataType == SQL_NUMERIC || iDataType == SQL_SMALLINT || iDataType == SRV_TDS_BIT || iDataType == SQL_REAL)
            {
                SQLINTEGER SQLBuffer3 = 0;
                char sCharData[32];

                if(rsTemp.GetData(iColumn+1, SQL_C_LONG, &SQLBuffer3, 32, (SQLINTEGER *)&iDataLen))
				//if(rsTemp.lColumnEx(iColumn + 1, &SQLBuffer3))
				{
                    if(iDataLen == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(sCharData, "%d", SQLBuffer3);
                        iDataLen = strlen(sCharData);
                        fwrite(&iDataLen, sizeof(iDataLen), 1, TargetHandle);
                        fwrite(sCharData, sizeof(char), iDataLen, TargetHandle);
                    }
                }
				else{
	                sprintf(sStatusText, "Failed to retreive data from column. Table: %s, Column: %d, Type: %d", CCI.sImportTable, iColumn, iDataType);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
				}
            }
            else if(iDataType == SQL_DOUBLE || iDataType == SQL_FLOAT)
            {
                SQLDOUBLE SQLBuffer4 = 0;
                char sCharData[32];

                if(rsTemp.GetData(iColumn+1, SQL_C_DOUBLE, &SQLBuffer4, 32, (SQLINTEGER *)&iDataLen))
				//if(rsTemp.dColumnEx(iColumn+1, &SQLBuffer4))
                {
                    if(iDataLen == -1)
                    {
                        WriteNull(TargetHandle);
                    }
                    else{
                        sprintf(sCharData, "%f", SQLBuffer4);
                        iDataLen = strlen(sCharData);
                        fwrite(&iDataLen, sizeof(iDataLen), 1, TargetHandle);
                        fwrite(sCharData, sizeof(char), iDataLen, TargetHandle);
                    }
                }
				else{
	                sprintf(sStatusText, "Failed to retreive data from column. Table: %s, Column: %d, Type: %d", CCI.sImportTable, iColumn, iDataType);
					WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
				}
            }
			else{
                sprintf(sStatusText, "Unknown SQL data type. Table: %s, Select column: %d, Type: %d", CCI.sImportTable, iColumn, iDataType);
				WriteLog(pSockSrvr->icClientID[iClient], sStatusText);
            }

            iColumn++;
        }
    }

    rsTemp.Close();

    if(TargetHandle) fclose(TargetHandle);
	
	return SQL_IMPORT_RESULT_OK;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
